package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.Synchronization;
import odata.msgraph.client.beta.entity.collection.request.SynchronizationJobCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SynchronizationTemplateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SynchronizationRequest extends EntityRequest<Synchronization> {

    public SynchronizationRequest(ContextPath contextPath) {
        super(Synchronization.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SynchronizationJobCollectionRequest jobs() {
        return new SynchronizationJobCollectionRequest(
                        contextPath.addSegment("jobs"));
    }

    public SynchronizationJobRequest jobs(String id) {
        return new SynchronizationJobRequest(contextPath.addSegment("jobs").addKeys(new NameValue(id.toString())));
    }

    public SynchronizationTemplateCollectionRequest templates() {
        return new SynchronizationTemplateCollectionRequest(
                        contextPath.addSegment("templates"));
    }

    public SynchronizationTemplateRequest templates(String id) {
        return new SynchronizationTemplateRequest(contextPath.addSegment("templates").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "Ping")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> ping() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.Ping"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
