package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.StringKeyStringValuePair;
import odata.msgraph.client.beta.complex.SynchronizationJobApplicationParameters;
import odata.msgraph.client.beta.complex.SynchronizationJobRestartCriteria;
import odata.msgraph.client.beta.complex.SynchronizationSecretKeyStringValuePair;
import odata.msgraph.client.beta.entity.SynchronizationJob;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SynchronizationJobRequest extends EntityRequest<SynchronizationJob> {

    public SynchronizationJobRequest(ContextPath contextPath) {
        super(SynchronizationJob.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SynchronizationSchemaRequest schema() {
        return new SynchronizationSchemaRequest(contextPath.addSegment("schema"));
    }

    @Action(name = "pause")
    @JsonIgnore
    public ActionRequestNoReturn pause() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.pause"), _parameters);
    }

    @Action(name = "provisionOnDemand")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<StringKeyStringValuePair> provisionOnDemand(List<SynchronizationJobApplicationParameters> parameters) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("parameters", "Collection(microsoft.graph.synchronizationJobApplicationParameters)", parameters)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<StringKeyStringValuePair>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.provisionOnDemand"), StringKeyStringValuePair.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "start")
    @JsonIgnore
    public ActionRequestNoReturn start() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.start"), _parameters);
    }

    @Action(name = "stop")
    @JsonIgnore
    public ActionRequestNoReturn stop() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stop"), _parameters);
    }

    @Action(name = "restart")
    @JsonIgnore
    public ActionRequestNoReturn restart(SynchronizationJobRestartCriteria criteria) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("criteria", "microsoft.graph.synchronizationJobRestartCriteria", criteria)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.restart"), _parameters);
    }

    @Action(name = "validateCredentials")
    @JsonIgnore
    public ActionRequestNoReturn validateCredentials(String applicationIdentifier, String templateId, Boolean useSavedCredentials, List<SynchronizationSecretKeyStringValuePair> credentials) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("applicationIdentifier", "Edm.String", Checks.checkIsAscii(applicationIdentifier))
            .put("templateId", "Edm.String", Checks.checkIsAscii(templateId))
            .put("useSavedCredentials", "Edm.Boolean", useSavedCredentials)
            .put("credentials", "Collection(microsoft.graph.synchronizationSecretKeyStringValuePair)", credentials)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.validateCredentials"), _parameters);
    }

}
