package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.StsPolicy;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class StsPolicyRequest extends EntityRequest<StsPolicy> {

    public StsPolicyRequest(ContextPath contextPath) {
        super(StsPolicy.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DirectoryObjectCollectionRequest appliesTo() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("appliesTo"));
    }

    public DirectoryObjectRequest appliesTo(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("appliesTo").addKeys(new NameValue(id.toString())));
    }

}
