package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.ItemActivityStat;
import odata.msgraph.client.beta.entity.Site;
import odata.msgraph.client.beta.entity.collection.request.BaseItemCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ColumnDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ContentTypeCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DriveCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ListCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SiteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SitePageCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SiteRequest extends EntityRequest<Site> {

    public SiteRequest(ContextPath contextPath) {
        super(Site.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ItemAnalyticsRequest analytics() {
        return new ItemAnalyticsRequest(contextPath.addSegment("analytics"));
    }

    public ColumnDefinitionCollectionRequest columns() {
        return new ColumnDefinitionCollectionRequest(
                        contextPath.addSegment("columns"));
    }

    public ColumnDefinitionRequest columns(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("columns").addKeys(new NameValue(id.toString())));
    }

    public ContentTypeCollectionRequest contentTypes() {
        return new ContentTypeCollectionRequest(
                        contextPath.addSegment("contentTypes"));
    }

    public ContentTypeRequest contentTypes(String id) {
        return new ContentTypeRequest(contextPath.addSegment("contentTypes").addKeys(new NameValue(id.toString())));
    }

    public DriveRequest drive() {
        return new DriveRequest(contextPath.addSegment("drive"));
    }

    public DriveCollectionRequest drives() {
        return new DriveCollectionRequest(
                        contextPath.addSegment("drives"));
    }

    public DriveRequest drives(String id) {
        return new DriveRequest(contextPath.addSegment("drives").addKeys(new NameValue(id.toString())));
    }

    public BaseItemCollectionRequest items() {
        return new BaseItemCollectionRequest(
                        contextPath.addSegment("items"));
    }

    public BaseItemRequest items(String id) {
        return new BaseItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id.toString())));
    }

    public ListCollectionRequest lists() {
        return new ListCollectionRequest(
                        contextPath.addSegment("lists"));
    }

    public ListRequest lists(String id) {
        return new ListRequest(contextPath.addSegment("lists").addKeys(new NameValue(id.toString())));
    }

    public SitePageCollectionRequest pages() {
        return new SitePageCollectionRequest(
                        contextPath.addSegment("pages"));
    }

    public SitePageRequest pages(String id) {
        return new SitePageRequest(contextPath.addSegment("pages").addKeys(new NameValue(id.toString())));
    }

    public SiteCollectionRequest sites() {
        return new SiteCollectionRequest(
                        contextPath.addSegment("sites"));
    }

    public SiteRequest sites(String id) {
        return new SiteRequest(contextPath.addSegment("sites").addKeys(new NameValue(id.toString())));
    }

    public OnenoteRequest onenote() {
        return new OnenoteRequest(contextPath.addSegment("onenote"));
    }

    @Function(name = "getActivitiesByInterval")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ItemActivityStat> getActivitiesByInterval(String startDateTime, String endDateTime, String interval) {
        Preconditions.checkNotNull(startDateTime, "startDateTime cannot be null");
        Preconditions.checkNotNull(endDateTime, "endDateTime cannot be null");
        Preconditions.checkNotNull(interval, "interval cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("startDateTime", "Edm.String", Checks.checkIsAscii(startDateTime))
            .put("endDateTime", "Edm.String", Checks.checkIsAscii(endDateTime))
            .put("interval", "Edm.String", Checks.checkIsAscii(interval))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getActivitiesByInterval"), ItemActivityStat.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getByPath")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Site> getByPath(String path) {
        Preconditions.checkNotNull(path, "path cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("path", "Edm.String", Checks.checkIsAscii(path))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Site>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getByPath"), Site.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
