package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.SitePage;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SitePageRequest extends EntityRequest<SitePage> {

    public SitePageRequest(ContextPath contextPath) {
        super(SitePage.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "publish")
    @JsonIgnore
    public ActionRequestNoReturn publish() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.publish"), _parameters);
    }

}
