package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SharedDriveItem;
import odata.msgraph.client.beta.entity.collection.request.DriveItemCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SharedDriveItemRequest extends EntityRequest<SharedDriveItem> {

    public SharedDriveItemRequest(ContextPath contextPath) {
        super(SharedDriveItem.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DriveItemRequest driveItem() {
        return new DriveItemRequest(contextPath.addSegment("driveItem"));
    }

    public DriveItemCollectionRequest items() {
        return new DriveItemCollectionRequest(
                        contextPath.addSegment("items"));
    }

    public DriveItemRequest items(String id) {
        return new DriveItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id.toString())));
    }

    public ListRequest list() {
        return new ListRequest(contextPath.addSegment("list"));
    }

    public ListItemRequest listItem() {
        return new ListItemRequest(contextPath.addSegment("listItem"));
    }

    public PermissionRequest permission() {
        return new PermissionRequest(contextPath.addSegment("permission"));
    }

    public DriveItemRequest root() {
        return new DriveItemRequest(contextPath.addSegment("root"));
    }

    public SiteRequest site() {
        return new SiteRequest(contextPath.addSegment("site"));
    }

}
