package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.Credential;
import odata.msgraph.client.beta.complex.PasswordSingleSignOnCredentialSet;
import odata.msgraph.client.beta.entity.ServicePrincipal;
import odata.msgraph.client.beta.entity.collection.request.AppRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ClaimsMappingPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EndpointCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.HomeRealmDiscoveryPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LicenseDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OAuth2PermissionGrantCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenIssuancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenLifetimePolicyCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ServicePrincipalRequest extends EntityRequest<ServicePrincipal> {

    public ServicePrincipalRequest(ContextPath contextPath) {
        super(ServicePrincipal.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AppRoleAssignmentCollectionRequest appRoleAssignedTo() {
        return new AppRoleAssignmentCollectionRequest(
                        contextPath.addSegment("appRoleAssignedTo"));
    }

    public AppRoleAssignmentRequest appRoleAssignedTo(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignedTo").addKeys(new NameValue(id.toString())));
    }

    public AppRoleAssignmentCollectionRequest appRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(
                        contextPath.addSegment("appRoleAssignments"));
    }

    public AppRoleAssignmentRequest appRoleAssignments(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignments").addKeys(new NameValue(id.toString())));
    }

    public ClaimsMappingPolicyCollectionRequest claimsMappingPolicies() {
        return new ClaimsMappingPolicyCollectionRequest(
                        contextPath.addSegment("claimsMappingPolicies"));
    }

    public ClaimsMappingPolicyRequest claimsMappingPolicies(String id) {
        return new ClaimsMappingPolicyRequest(contextPath.addSegment("claimsMappingPolicies").addKeys(new NameValue(id.toString())));
    }

    public HomeRealmDiscoveryPolicyCollectionRequest homeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(
                        contextPath.addSegment("homeRealmDiscoveryPolicies"));
    }

    public HomeRealmDiscoveryPolicyRequest homeRealmDiscoveryPolicies(String id) {
        return new HomeRealmDiscoveryPolicyRequest(contextPath.addSegment("homeRealmDiscoveryPolicies").addKeys(new NameValue(id.toString())));
    }

    public EndpointCollectionRequest endpoints() {
        return new EndpointCollectionRequest(
                        contextPath.addSegment("endpoints"));
    }

    public EndpointRequest endpoints(String id) {
        return new EndpointRequest(contextPath.addSegment("endpoints").addKeys(new NameValue(id.toString())));
    }

    public OAuth2PermissionGrantCollectionRequest oauth2PermissionGrants() {
        return new OAuth2PermissionGrantCollectionRequest(
                        contextPath.addSegment("oauth2PermissionGrants"));
    }

    public OAuth2PermissionGrantRequest oauth2PermissionGrants(String id) {
        return new OAuth2PermissionGrantRequest(contextPath.addSegment("oauth2PermissionGrants").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("memberOf"));
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("transitiveMemberOf"));
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest createdObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("createdObjects"));
    }

    public DirectoryObjectRequest createdObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("createdObjects").addKeys(new NameValue(id.toString())));
    }

    public LicenseDetailsCollectionRequest licenseDetails() {
        return new LicenseDetailsCollectionRequest(
                        contextPath.addSegment("licenseDetails"));
    }

    public LicenseDetailsRequest licenseDetails(String id) {
        return new LicenseDetailsRequest(contextPath.addSegment("licenseDetails").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest owners() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("owners"));
    }

    public DirectoryObjectRequest owners(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("owners").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest ownedObjects() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("ownedObjects"));
    }

    public DirectoryObjectRequest ownedObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("ownedObjects").addKeys(new NameValue(id.toString())));
    }

    public TokenIssuancePolicyCollectionRequest tokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(
                        contextPath.addSegment("tokenIssuancePolicies"));
    }

    public TokenIssuancePolicyRequest tokenIssuancePolicies(String id) {
        return new TokenIssuancePolicyRequest(contextPath.addSegment("tokenIssuancePolicies").addKeys(new NameValue(id.toString())));
    }

    public TokenLifetimePolicyCollectionRequest tokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(
                        contextPath.addSegment("tokenLifetimePolicies"));
    }

    public TokenLifetimePolicyRequest tokenLifetimePolicies(String id) {
        return new TokenLifetimePolicyRequest(contextPath.addSegment("tokenLifetimePolicies").addKeys(new NameValue(id.toString())));
    }

    public SynchronizationRequest synchronization() {
        return new SynchronizationRequest(contextPath.addSegment("synchronization"));
    }

    @Action(name = "createPasswordSingleSignOnCredentials")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PasswordSingleSignOnCredentialSet> createPasswordSingleSignOnCredentials(String id, List<Credential> credentials) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Preconditions.checkNotNull(credentials, "credentials cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("credentials", "Collection(microsoft.graph.credential)", credentials)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PasswordSingleSignOnCredentialSet>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createPasswordSingleSignOnCredentials"), PasswordSingleSignOnCredentialSet.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "getPasswordSingleSignOnCredentials")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PasswordSingleSignOnCredentialSet> getPasswordSingleSignOnCredentials(String id) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PasswordSingleSignOnCredentialSet>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPasswordSingleSignOnCredentials"), PasswordSingleSignOnCredentialSet.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "deletePasswordSingleSignOnCredentials")
    @JsonIgnore
    public ActionRequestNoReturn deletePasswordSingleSignOnCredentials(String id) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deletePasswordSingleSignOnCredentials"), _parameters);
    }

    @Action(name = "updatePasswordSingleSignOnCredentials")
    @JsonIgnore
    public ActionRequestNoReturn updatePasswordSingleSignOnCredentials(String id, List<Credential> credentials) {
        Preconditions.checkNotNull(id, "id cannot be null");
        Preconditions.checkNotNull(credentials, "credentials cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("id", "Edm.String", Checks.checkIsAscii(id))
            .put("credentials", "Collection(microsoft.graph.credential)", credentials)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.updatePasswordSingleSignOnCredentials"), _parameters);
    }

}
