package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SensitivityLabel;
import odata.msgraph.client.beta.entity.collection.request.SensitivityLabelCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SensitivityLabelRequest extends EntityRequest<SensitivityLabel> {

    public SensitivityLabelRequest(ContextPath contextPath) {
        super(SensitivityLabel.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SensitivityLabelCollectionRequest sublabels() {
        return new SensitivityLabelCollectionRequest(
                        contextPath.addSegment("sublabels"));
    }

    public SensitivityLabelRequest sublabels(String id) {
        return new SensitivityLabelRequest(contextPath.addSegment("sublabels").addKeys(new NameValue(id.toString())));
    }

}
