package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Security;
import odata.msgraph.client.beta.entity.collection.request.AlertCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CloudAppSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.DomainSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.FileSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.HostSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.IpSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProviderTenantSettingCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecureScoreCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecureScoreControlProfileCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecurityActionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TiIndicatorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserSecurityProfileCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SecurityRequest extends EntityRequest<Security> {

    public SecurityRequest(ContextPath contextPath) {
        super(Security.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AlertCollectionRequest alerts() {
        return new AlertCollectionRequest(
                        contextPath.addSegment("alerts"));
    }

    public AlertRequest alerts(String id) {
        return new AlertRequest(contextPath.addSegment("alerts").addKeys(new NameValue(id.toString())));
    }

    public CloudAppSecurityProfileCollectionRequest cloudAppSecurityProfiles() {
        return new CloudAppSecurityProfileCollectionRequest(
                        contextPath.addSegment("cloudAppSecurityProfiles"));
    }

    public CloudAppSecurityProfileRequest cloudAppSecurityProfiles(String id) {
        return new CloudAppSecurityProfileRequest(contextPath.addSegment("cloudAppSecurityProfiles").addKeys(new NameValue(id.toString())));
    }

    public DomainSecurityProfileCollectionRequest domainSecurityProfiles() {
        return new DomainSecurityProfileCollectionRequest(
                        contextPath.addSegment("domainSecurityProfiles"));
    }

    public DomainSecurityProfileRequest domainSecurityProfiles(String id) {
        return new DomainSecurityProfileRequest(contextPath.addSegment("domainSecurityProfiles").addKeys(new NameValue(id.toString())));
    }

    public FileSecurityProfileCollectionRequest fileSecurityProfiles() {
        return new FileSecurityProfileCollectionRequest(
                        contextPath.addSegment("fileSecurityProfiles"));
    }

    public FileSecurityProfileRequest fileSecurityProfiles(String id) {
        return new FileSecurityProfileRequest(contextPath.addSegment("fileSecurityProfiles").addKeys(new NameValue(id.toString())));
    }

    public HostSecurityProfileCollectionRequest hostSecurityProfiles() {
        return new HostSecurityProfileCollectionRequest(
                        contextPath.addSegment("hostSecurityProfiles"));
    }

    public HostSecurityProfileRequest hostSecurityProfiles(String id) {
        return new HostSecurityProfileRequest(contextPath.addSegment("hostSecurityProfiles").addKeys(new NameValue(id.toString())));
    }

    public IpSecurityProfileCollectionRequest ipSecurityProfiles() {
        return new IpSecurityProfileCollectionRequest(
                        contextPath.addSegment("ipSecurityProfiles"));
    }

    public IpSecurityProfileRequest ipSecurityProfiles(String id) {
        return new IpSecurityProfileRequest(contextPath.addSegment("ipSecurityProfiles").addKeys(new NameValue(id.toString())));
    }

    public ProviderTenantSettingCollectionRequest providerTenantSettings() {
        return new ProviderTenantSettingCollectionRequest(
                        contextPath.addSegment("providerTenantSettings"));
    }

    public ProviderTenantSettingRequest providerTenantSettings(String id) {
        return new ProviderTenantSettingRequest(contextPath.addSegment("providerTenantSettings").addKeys(new NameValue(id.toString())));
    }

    public SecureScoreControlProfileCollectionRequest secureScoreControlProfiles() {
        return new SecureScoreControlProfileCollectionRequest(
                        contextPath.addSegment("secureScoreControlProfiles"));
    }

    public SecureScoreControlProfileRequest secureScoreControlProfiles(String id) {
        return new SecureScoreControlProfileRequest(contextPath.addSegment("secureScoreControlProfiles").addKeys(new NameValue(id.toString())));
    }

    public SecureScoreCollectionRequest secureScores() {
        return new SecureScoreCollectionRequest(
                        contextPath.addSegment("secureScores"));
    }

    public SecureScoreRequest secureScores(String id) {
        return new SecureScoreRequest(contextPath.addSegment("secureScores").addKeys(new NameValue(id.toString())));
    }

    public TiIndicatorCollectionRequest tiIndicators() {
        return new TiIndicatorCollectionRequest(
                        contextPath.addSegment("tiIndicators"));
    }

    public TiIndicatorRequest tiIndicators(String id) {
        return new TiIndicatorRequest(contextPath.addSegment("tiIndicators").addKeys(new NameValue(id.toString())));
    }

    public UserSecurityProfileCollectionRequest userSecurityProfiles() {
        return new UserSecurityProfileCollectionRequest(
                        contextPath.addSegment("userSecurityProfiles"));
    }

    public UserSecurityProfileRequest userSecurityProfiles(String id) {
        return new UserSecurityProfileRequest(contextPath.addSegment("userSecurityProfiles").addKeys(new NameValue(id.toString())));
    }

    public SecurityActionCollectionRequest securityActions() {
        return new SecurityActionCollectionRequest(
                        contextPath.addSegment("securityActions"));
    }

    public SecurityActionRequest securityActions(String id) {
        return new SecurityActionRequest(contextPath.addSegment("securityActions").addKeys(new NameValue(id.toString())));
    }

}
