package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SecurityBaselineTemplate;
import odata.msgraph.client.beta.entity.collection.request.SecurityBaselineCategoryStateSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecurityBaselineDeviceStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SecurityBaselineTemplateRequest extends EntityRequest<SecurityBaselineTemplate> {

    public SecurityBaselineTemplateRequest(ContextPath contextPath) {
        super(SecurityBaselineTemplate.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SecurityBaselineStateSummaryRequest deviceStateSummary() {
        return new SecurityBaselineStateSummaryRequest(contextPath.addSegment("deviceStateSummary"));
    }

    public SecurityBaselineDeviceStateCollectionRequest deviceStates() {
        return new SecurityBaselineDeviceStateCollectionRequest(
                        contextPath.addSegment("deviceStates"));
    }

    public SecurityBaselineDeviceStateRequest deviceStates(String id) {
        return new SecurityBaselineDeviceStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id.toString())));
    }

    public SecurityBaselineCategoryStateSummaryCollectionRequest categoryDeviceStateSummaries() {
        return new SecurityBaselineCategoryStateSummaryCollectionRequest(
                        contextPath.addSegment("categoryDeviceStateSummaries"));
    }

    public SecurityBaselineCategoryStateSummaryRequest categoryDeviceStateSummaries(String id) {
        return new SecurityBaselineCategoryStateSummaryRequest(contextPath.addSegment("categoryDeviceStateSummaries").addKeys(new NameValue(id.toString())));
    }

}
