package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SecurityBaselineState;
import odata.msgraph.client.beta.entity.collection.request.SecurityBaselineSettingStateCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SecurityBaselineStateRequest extends EntityRequest<SecurityBaselineState> {

    public SecurityBaselineStateRequest(ContextPath contextPath) {
        super(SecurityBaselineState.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SecurityBaselineSettingStateCollectionRequest settingStates() {
        return new SecurityBaselineSettingStateCollectionRequest(
                        contextPath.addSegment("settingStates"));
    }

    public SecurityBaselineSettingStateRequest settingStates(String id) {
        return new SecurityBaselineSettingStateRequest(contextPath.addSegment("settingStates").addKeys(new NameValue(id.toString())));
    }

}
