package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.SecurityAction;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SecurityActionRequest extends EntityRequest<SecurityAction> {

    public SecurityActionRequest(ContextPath contextPath) {
        super(SecurityAction.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "cancelSecurityAction")
    @JsonIgnore
    public ActionRequestNoReturn cancelSecurityAction() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancelSecurityAction"), _parameters);
    }

}
