package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SectionGroup;
import odata.msgraph.client.beta.entity.collection.request.OnenoteSectionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SectionGroupCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SectionGroupRequest extends EntityRequest<SectionGroup> {

    public SectionGroupRequest(ContextPath contextPath) {
        super(SectionGroup.class, contextPath, SchemaInfo.INSTANCE);
    }

    public NotebookRequest parentNotebook() {
        return new NotebookRequest(contextPath.addSegment("parentNotebook"));
    }

    public SectionGroupRequest parentSectionGroup() {
        return new SectionGroupRequest(contextPath.addSegment("parentSectionGroup"));
    }

    public OnenoteSectionCollectionRequest sections() {
        return new OnenoteSectionCollectionRequest(
                        contextPath.addSegment("sections"));
    }

    public OnenoteSectionRequest sections(String id) {
        return new OnenoteSectionRequest(contextPath.addSegment("sections").addKeys(new NameValue(id.toString())));
    }

    public SectionGroupCollectionRequest sectionGroups() {
        return new SectionGroupCollectionRequest(
                        contextPath.addSegment("sectionGroups"));
    }

    public SectionGroupRequest sectionGroups(String id) {
        return new SectionGroupRequest(contextPath.addSegment("sectionGroups").addKeys(new NameValue(id.toString())));
    }

}
