package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.SearchResponse;
import odata.msgraph.client.beta.entity.Search;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SearchRequest extends EntityRequest<Search> {

    public SearchRequest(ContextPath contextPath) {
        super(Search.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "query")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SearchResponse> query(List<odata.msgraph.client.beta.complex.SearchRequest> requests) {
        Preconditions.checkNotNull(requests, "requests cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("requests", "Collection(microsoft.graph.searchRequest)", requests)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.query"), SearchResponse.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
