package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.time.OffsetDateTime;
import java.util.Map;

import odata.msgraph.client.beta.entity.Schedule;
import odata.msgraph.client.beta.entity.collection.request.OfferShiftRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OpenShiftChangeRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.OpenShiftCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SchedulingGroupCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ShiftCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SwapShiftsChangeRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TimeOffCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TimeOffReasonCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TimeOffRequestCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ScheduleRequest extends EntityRequest<Schedule> {

    public ScheduleRequest(ContextPath contextPath) {
        super(Schedule.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ShiftCollectionRequest shifts() {
        return new ShiftCollectionRequest(
                        contextPath.addSegment("shifts"));
    }

    public ShiftRequest shifts(String id) {
        return new ShiftRequest(contextPath.addSegment("shifts").addKeys(new NameValue(id.toString())));
    }

    public OpenShiftCollectionRequest openShifts() {
        return new OpenShiftCollectionRequest(
                        contextPath.addSegment("openShifts"));
    }

    public OpenShiftRequest openShifts(String id) {
        return new OpenShiftRequest(contextPath.addSegment("openShifts").addKeys(new NameValue(id.toString())));
    }

    public TimeOffCollectionRequest timesOff() {
        return new TimeOffCollectionRequest(
                        contextPath.addSegment("timesOff"));
    }

    public TimeOffRequest timesOff(String id) {
        return new TimeOffRequest(contextPath.addSegment("timesOff").addKeys(new NameValue(id.toString())));
    }

    public TimeOffReasonCollectionRequest timeOffReasons() {
        return new TimeOffReasonCollectionRequest(
                        contextPath.addSegment("timeOffReasons"));
    }

    public TimeOffReasonRequest timeOffReasons(String id) {
        return new TimeOffReasonRequest(contextPath.addSegment("timeOffReasons").addKeys(new NameValue(id.toString())));
    }

    public SchedulingGroupCollectionRequest schedulingGroups() {
        return new SchedulingGroupCollectionRequest(
                        contextPath.addSegment("schedulingGroups"));
    }

    public SchedulingGroupRequest schedulingGroups(String id) {
        return new SchedulingGroupRequest(contextPath.addSegment("schedulingGroups").addKeys(new NameValue(id.toString())));
    }

    public SwapShiftsChangeRequestCollectionRequest swapShiftsChangeRequests() {
        return new SwapShiftsChangeRequestCollectionRequest(
                        contextPath.addSegment("swapShiftsChangeRequests"));
    }

    public SwapShiftsChangeRequestRequest swapShiftsChangeRequests(String id) {
        return new SwapShiftsChangeRequestRequest(contextPath.addSegment("swapShiftsChangeRequests").addKeys(new NameValue(id.toString())));
    }

    public OpenShiftChangeRequestCollectionRequest openShiftChangeRequests() {
        return new OpenShiftChangeRequestCollectionRequest(
                        contextPath.addSegment("openShiftChangeRequests"));
    }

    public OpenShiftChangeRequestRequest openShiftChangeRequests(String id) {
        return new OpenShiftChangeRequestRequest(contextPath.addSegment("openShiftChangeRequests").addKeys(new NameValue(id.toString())));
    }

    public OfferShiftRequestCollectionRequest offerShiftRequests() {
        return new OfferShiftRequestCollectionRequest(
                        contextPath.addSegment("offerShiftRequests"));
    }

    public OfferShiftRequestRequest offerShiftRequests(String id) {
        return new OfferShiftRequestRequest(contextPath.addSegment("offerShiftRequests").addKeys(new NameValue(id.toString())));
    }

    public TimeOffRequestCollectionRequest timeOffRequests() {
        return new TimeOffRequestCollectionRequest(
                        contextPath.addSegment("timeOffRequests"));
    }

    public TimeOffRequestRequest timeOffRequests(String id) {
        return new TimeOffRequestRequest(contextPath.addSegment("timeOffRequests").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "share")
    @JsonIgnore
    public ActionRequestNoReturn share(Boolean notifyTeam, OffsetDateTime startDateTime, OffsetDateTime endDateTime) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("notifyTeam", "Edm.Boolean", notifyTeam)
            .put("startDateTime", "Edm.DateTimeOffset", startDateTime)
            .put("endDateTime", "Edm.DateTimeOffset", endDateTime)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.share"), _parameters);
    }

}
