package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.ScheduleChangeRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ScheduleChangeRequestRequest extends EntityRequest<ScheduleChangeRequest> {

    public ScheduleChangeRequestRequest(ContextPath contextPath) {
        super(ScheduleChangeRequest.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "approve")
    @JsonIgnore
    public ActionRequestNoReturn approve(String message) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("message", "Edm.String", Checks.checkIsAscii(message))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.approve"), _parameters);
    }

    @Action(name = "decline")
    @JsonIgnore
    public ActionRequestNoReturn decline(String message) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("message", "Edm.String", Checks.checkIsAscii(message))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.decline"), _parameters);
    }

}
