package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.SalesQuote;
import odata.msgraph.client.beta.entity.collection.request.SalesQuoteLineCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SalesQuoteRequest extends EntityRequest<SalesQuote> {

    public SalesQuoteRequest(ContextPath contextPath) {
        super(SalesQuote.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SalesQuoteLineCollectionRequest salesQuoteLines() {
        return new SalesQuoteLineCollectionRequest(
                        contextPath.addSegment("salesQuoteLines"));
    }

    public SalesQuoteLineRequest salesQuoteLines(String id) {
        return new SalesQuoteLineRequest(contextPath.addSegment("salesQuoteLines").addKeys(new NameValue(id.toString())));
    }

    public CustomerRequest customer() {
        return new CustomerRequest(contextPath.addSegment("customer"));
    }

    public CurrencyRequest currency() {
        return new CurrencyRequest(contextPath.addSegment("currency"));
    }

    public PaymentTermRequest paymentTerm() {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerm"));
    }

    public ShipmentMethodRequest shipmentMethod() {
        return new ShipmentMethodRequest(contextPath.addSegment("shipmentMethod"));
    }

    @Action(name = "makeInvoice")
    @JsonIgnore
    public ActionRequestNoReturn makeInvoice() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.makeInvoice"), _parameters);
    }

    @Action(name = "send")
    @JsonIgnore
    public ActionRequestNoReturn send() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.send"), _parameters);
    }

}
