package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.SalesQuoteLine;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SalesQuoteLineRequest extends EntityRequest<SalesQuoteLine> {

    public SalesQuoteLineRequest(ContextPath contextPath) {
        super(SalesQuoteLine.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ItemRequest item() {
        return new ItemRequest(contextPath.addSegment("item"));
    }

    public AccountRequest account() {
        return new AccountRequest(contextPath.addSegment("account"));
    }

}
