package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SalesOrder;
import odata.msgraph.client.beta.entity.collection.request.SalesOrderLineCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SalesOrderRequest extends EntityRequest<SalesOrder> {

    public SalesOrderRequest(ContextPath contextPath) {
        super(SalesOrder.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SalesOrderLineCollectionRequest salesOrderLines() {
        return new SalesOrderLineCollectionRequest(
                        contextPath.addSegment("salesOrderLines"));
    }

    public SalesOrderLineRequest salesOrderLines(String id) {
        return new SalesOrderLineRequest(contextPath.addSegment("salesOrderLines").addKeys(new NameValue(id.toString())));
    }

    public CustomerRequest customer() {
        return new CustomerRequest(contextPath.addSegment("customer"));
    }

    public CurrencyRequest currency() {
        return new CurrencyRequest(contextPath.addSegment("currency"));
    }

    public PaymentTermRequest paymentTerm() {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerm"));
    }

}
