package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SalesCreditMemo;
import odata.msgraph.client.beta.entity.collection.request.SalesCreditMemoLineCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class SalesCreditMemoRequest extends EntityRequest<SalesCreditMemo> {

    public SalesCreditMemoRequest(ContextPath contextPath) {
        super(SalesCreditMemo.class, contextPath, SchemaInfo.INSTANCE);
    }

    public SalesCreditMemoLineCollectionRequest salesCreditMemoLines() {
        return new SalesCreditMemoLineCollectionRequest(
                        contextPath.addSegment("salesCreditMemoLines"));
    }

    public SalesCreditMemoLineRequest salesCreditMemoLines(String id) {
        return new SalesCreditMemoLineRequest(contextPath.addSegment("salesCreditMemoLines").addKeys(new NameValue(id.toString())));
    }

    public CustomerRequest customer() {
        return new CustomerRequest(contextPath.addSegment("customer"));
    }

    public CurrencyRequest currency() {
        return new CurrencyRequest(contextPath.addSegment("currency"));
    }

    public PaymentTermRequest paymentTerm() {
        return new PaymentTermRequest(contextPath.addSegment("paymentTerm"));
    }

}
