package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.RoomList;
import odata.msgraph.client.beta.entity.collection.request.RoomCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class RoomListRequest extends EntityRequest<RoomList> {

    public RoomListRequest(ContextPath contextPath) {
        super(RoomList.class, contextPath, SchemaInfo.INSTANCE);
    }

    public RoomCollectionRequest rooms() {
        return new RoomCollectionRequest(
                        contextPath.addSegment("rooms"));
    }

    public RoomRequest rooms(String id) {
        return new RoomRequest(contextPath.addSegment("rooms").addKeys(new NameValue(id.toString())));
    }

}
