package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.RoleManagement;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class RoleManagementRequest extends EntityRequest<RoleManagement> {

    public RoleManagementRequest(ContextPath contextPath) {
        super(RoleManagement.class, contextPath, SchemaInfo.INSTANCE);
    }

    public RbacApplicationRequest directory() {
        return new RbacApplicationRequest(contextPath.addSegment("directory"));
    }

    public RbacApplicationMultipleRequest deviceManagement() {
        return new RbacApplicationMultipleRequest(contextPath.addSegment("deviceManagement"));
    }

}
