package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.RoleDefinition;
import odata.msgraph.client.beta.entity.collection.request.RoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class RoleDefinitionRequest extends EntityRequest<RoleDefinition> {

    public RoleDefinitionRequest(ContextPath contextPath) {
        super(RoleDefinition.class, contextPath, SchemaInfo.INSTANCE);
    }

    public RoleAssignmentCollectionRequest roleAssignments() {
        return new RoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"));
    }

    public RoleAssignmentRequest roleAssignments(String id) {
        return new RoleAssignmentRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id.toString())));
    }

}
