package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.RiskyUser;
import odata.msgraph.client.beta.entity.collection.request.RiskyUserHistoryItemCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class RiskyUserRequest extends EntityRequest<RiskyUser> {

    public RiskyUserRequest(ContextPath contextPath) {
        super(RiskyUser.class, contextPath, SchemaInfo.INSTANCE);
    }

    public RiskyUserHistoryItemCollectionRequest history() {
        return new RiskyUserHistoryItemCollectionRequest(
                        contextPath.addSegment("history"));
    }

    public RiskyUserHistoryItemRequest history(String id) {
        return new RiskyUserHistoryItemRequest(contextPath.addSegment("history").addKeys(new NameValue(id.toString())));
    }

}
