package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ReviewSet;
import odata.msgraph.client.beta.entity.collection.request.ReviewSetQueryCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ReviewSetRequest extends EntityRequest<ReviewSet> {

    public ReviewSetRequest(ContextPath contextPath) {
        super(ReviewSet.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ReviewSetQueryCollectionRequest queries() {
        return new ReviewSetQueryCollectionRequest(
                        contextPath.addSegment("queries"));
    }

    public ReviewSetQueryRequest queries(String id) {
        return new ReviewSetQueryRequest(contextPath.addSegment("queries").addKeys(new NameValue(id.toString())));
    }

}
