package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.ResourceOperation;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ResourceOperationRequest extends EntityRequest<ResourceOperation> {

    public ResourceOperationRequest(ContextPath contextPath) {
        super(ResourceOperation.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Function(name = "getScopesForUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getScopesForUser(String userid) {
        Preconditions.checkNotNull(userid, "userid cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userid", "Edm.String", Checks.checkIsAscii(userid))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getScopesForUser"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
