package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.time.LocalDate;
import java.util.Map;

import odata.msgraph.client.beta.complex.Report;
import odata.msgraph.client.beta.entity.ApplicationSignInSummary;
import odata.msgraph.client.beta.entity.AzureADFeatureUsage;
import odata.msgraph.client.beta.entity.AzureADLicenseUsage;
import odata.msgraph.client.beta.entity.AzureADUserFeatureUsage;
import odata.msgraph.client.beta.entity.CredentialUsageSummary;
import odata.msgraph.client.beta.entity.CredentialUserRegistrationCount;
import odata.msgraph.client.beta.entity.EmailActivitySummary;
import odata.msgraph.client.beta.entity.EmailActivityUserDetail;
import odata.msgraph.client.beta.entity.EmailAppUsageAppsUserCounts;
import odata.msgraph.client.beta.entity.EmailAppUsageUserCounts;
import odata.msgraph.client.beta.entity.EmailAppUsageUserDetail;
import odata.msgraph.client.beta.entity.EmailAppUsageVersionsUserCounts;
import odata.msgraph.client.beta.entity.MailboxUsageDetail;
import odata.msgraph.client.beta.entity.MailboxUsageMailboxCounts;
import odata.msgraph.client.beta.entity.MailboxUsageQuotaStatusMailboxCounts;
import odata.msgraph.client.beta.entity.MailboxUsageStorage;
import odata.msgraph.client.beta.entity.Office365ActivationCounts;
import odata.msgraph.client.beta.entity.Office365ActivationsUserCounts;
import odata.msgraph.client.beta.entity.Office365ActivationsUserDetail;
import odata.msgraph.client.beta.entity.Office365ActiveUserCounts;
import odata.msgraph.client.beta.entity.Office365ActiveUserDetail;
import odata.msgraph.client.beta.entity.Office365GroupsActivityCounts;
import odata.msgraph.client.beta.entity.Office365GroupsActivityDetail;
import odata.msgraph.client.beta.entity.Office365GroupsActivityFileCounts;
import odata.msgraph.client.beta.entity.Office365GroupsActivityGroupCounts;
import odata.msgraph.client.beta.entity.Office365GroupsActivityStorage;
import odata.msgraph.client.beta.entity.Office365ServicesUserCounts;
import odata.msgraph.client.beta.entity.OneDriveActivityUserDetail;
import odata.msgraph.client.beta.entity.OneDriveUsageAccountCounts;
import odata.msgraph.client.beta.entity.OneDriveUsageAccountDetail;
import odata.msgraph.client.beta.entity.OneDriveUsageFileCounts;
import odata.msgraph.client.beta.entity.RelyingPartyDetailedSummary;
import odata.msgraph.client.beta.entity.ReportRoot;
import odata.msgraph.client.beta.entity.SharePointActivityPages;
import odata.msgraph.client.beta.entity.SharePointActivityUserCounts;
import odata.msgraph.client.beta.entity.SharePointActivityUserDetail;
import odata.msgraph.client.beta.entity.SharePointSiteUsageDetail;
import odata.msgraph.client.beta.entity.SharePointSiteUsageFileCounts;
import odata.msgraph.client.beta.entity.SharePointSiteUsagePages;
import odata.msgraph.client.beta.entity.SharePointSiteUsageSiteCounts;
import odata.msgraph.client.beta.entity.SiteActivitySummary;
import odata.msgraph.client.beta.entity.SiteUsageStorage;
import odata.msgraph.client.beta.entity.SkypeForBusinessActivityCounts;
import odata.msgraph.client.beta.entity.SkypeForBusinessActivityUserCounts;
import odata.msgraph.client.beta.entity.SkypeForBusinessActivityUserDetail;
import odata.msgraph.client.beta.entity.SkypeForBusinessDeviceUsageDistributionUserCounts;
import odata.msgraph.client.beta.entity.SkypeForBusinessDeviceUsageUserCounts;
import odata.msgraph.client.beta.entity.SkypeForBusinessDeviceUsageUserDetail;
import odata.msgraph.client.beta.entity.SkypeForBusinessOrganizerActivityCounts;
import odata.msgraph.client.beta.entity.SkypeForBusinessOrganizerActivityMinuteCounts;
import odata.msgraph.client.beta.entity.SkypeForBusinessOrganizerActivityUserCounts;
import odata.msgraph.client.beta.entity.SkypeForBusinessParticipantActivityCounts;
import odata.msgraph.client.beta.entity.SkypeForBusinessParticipantActivityMinuteCounts;
import odata.msgraph.client.beta.entity.SkypeForBusinessParticipantActivityUserCounts;
import odata.msgraph.client.beta.entity.SkypeForBusinessPeerToPeerActivityCounts;
import odata.msgraph.client.beta.entity.SkypeForBusinessPeerToPeerActivityMinuteCounts;
import odata.msgraph.client.beta.entity.SkypeForBusinessPeerToPeerActivityUserCounts;
import odata.msgraph.client.beta.entity.TeamsDeviceUsageDistributionUserCounts;
import odata.msgraph.client.beta.entity.TeamsDeviceUsageUserCounts;
import odata.msgraph.client.beta.entity.TeamsDeviceUsageUserDetail;
import odata.msgraph.client.beta.entity.TeamsUserActivityCounts;
import odata.msgraph.client.beta.entity.TeamsUserActivityUserCounts;
import odata.msgraph.client.beta.entity.TeamsUserActivityUserDetail;
import odata.msgraph.client.beta.entity.YammerActivitySummary;
import odata.msgraph.client.beta.entity.YammerActivityUserDetail;
import odata.msgraph.client.beta.entity.YammerDeviceUsageDistributionUserCounts;
import odata.msgraph.client.beta.entity.YammerDeviceUsageUserCounts;
import odata.msgraph.client.beta.entity.YammerDeviceUsageUserDetail;
import odata.msgraph.client.beta.entity.YammerGroupsActivityCounts;
import odata.msgraph.client.beta.entity.YammerGroupsActivityDetail;
import odata.msgraph.client.beta.entity.YammerGroupsActivityGroupCounts;
import odata.msgraph.client.beta.entity.collection.request.ApplicationSignInDetailedSummaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.CredentialUserRegistrationDetailsCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintUsageSummaryByPrinterCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintUsageSummaryByUserCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserCredentialUsageDetailsCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ReportRootRequest extends EntityRequest<ReportRoot> {

    public ReportRootRequest(ContextPath contextPath) {
        super(ReportRoot.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ApplicationSignInDetailedSummaryCollectionRequest applicationSignInDetailedSummary() {
        return new ApplicationSignInDetailedSummaryCollectionRequest(
                        contextPath.addSegment("applicationSignInDetailedSummary"));
    }

    public ApplicationSignInDetailedSummaryRequest applicationSignInDetailedSummary(String id) {
        return new ApplicationSignInDetailedSummaryRequest(contextPath.addSegment("applicationSignInDetailedSummary").addKeys(new NameValue(id.toString())));
    }

    public CredentialUserRegistrationDetailsCollectionRequest credentialUserRegistrationDetails() {
        return new CredentialUserRegistrationDetailsCollectionRequest(
                        contextPath.addSegment("credentialUserRegistrationDetails"));
    }

    public CredentialUserRegistrationDetailsRequest credentialUserRegistrationDetails(String id) {
        return new CredentialUserRegistrationDetailsRequest(contextPath.addSegment("credentialUserRegistrationDetails").addKeys(new NameValue(id.toString())));
    }

    public UserCredentialUsageDetailsCollectionRequest userCredentialUsageDetails() {
        return new UserCredentialUsageDetailsCollectionRequest(
                        contextPath.addSegment("userCredentialUsageDetails"));
    }

    public UserCredentialUsageDetailsRequest userCredentialUsageDetails(String id) {
        return new UserCredentialUsageDetailsRequest(contextPath.addSegment("userCredentialUsageDetails").addKeys(new NameValue(id.toString())));
    }

    public PrintUsageSummaryByUserCollectionRequest dailyPrintUsageSummariesByUser() {
        return new PrintUsageSummaryByUserCollectionRequest(
                        contextPath.addSegment("dailyPrintUsageSummariesByUser"));
    }

    public PrintUsageSummaryByUserRequest dailyPrintUsageSummariesByUser(String id) {
        return new PrintUsageSummaryByUserRequest(contextPath.addSegment("dailyPrintUsageSummariesByUser").addKeys(new NameValue(id.toString())));
    }

    public PrintUsageSummaryByUserCollectionRequest monthlyPrintUsageSummariesByUser() {
        return new PrintUsageSummaryByUserCollectionRequest(
                        contextPath.addSegment("monthlyPrintUsageSummariesByUser"));
    }

    public PrintUsageSummaryByUserRequest monthlyPrintUsageSummariesByUser(String id) {
        return new PrintUsageSummaryByUserRequest(contextPath.addSegment("monthlyPrintUsageSummariesByUser").addKeys(new NameValue(id.toString())));
    }

    public PrintUsageSummaryByPrinterCollectionRequest dailyPrintUsageSummariesByPrinter() {
        return new PrintUsageSummaryByPrinterCollectionRequest(
                        contextPath.addSegment("dailyPrintUsageSummariesByPrinter"));
    }

    public PrintUsageSummaryByPrinterRequest dailyPrintUsageSummariesByPrinter(String id) {
        return new PrintUsageSummaryByPrinterRequest(contextPath.addSegment("dailyPrintUsageSummariesByPrinter").addKeys(new NameValue(id.toString())));
    }

    public PrintUsageSummaryByPrinterCollectionRequest monthlyPrintUsageSummariesByPrinter() {
        return new PrintUsageSummaryByPrinterCollectionRequest(
                        contextPath.addSegment("monthlyPrintUsageSummariesByPrinter"));
    }

    public PrintUsageSummaryByPrinterRequest monthlyPrintUsageSummariesByPrinter(String id) {
        return new PrintUsageSummaryByPrinterRequest(contextPath.addSegment("monthlyPrintUsageSummariesByPrinter").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "getAzureADLicenseUsage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AzureADLicenseUsage> getAzureADLicenseUsage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAzureADLicenseUsage"), AzureADLicenseUsage.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getAzureADUserFeatureUsage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AzureADUserFeatureUsage> getAzureADUserFeatureUsage() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAzureADUserFeatureUsage"), AzureADUserFeatureUsage.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getAzureADFeatureUsage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<AzureADFeatureUsage> getAzureADFeatureUsage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAzureADFeatureUsage"), AzureADFeatureUsage.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getAzureADApplicationSignInSummary")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ApplicationSignInSummary> getAzureADApplicationSignInSummary(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getAzureADApplicationSignInSummary"), ApplicationSignInSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getCredentialUserRegistrationCount")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CredentialUserRegistrationCount> getCredentialUserRegistrationCount() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCredentialUserRegistrationCount"), CredentialUserRegistrationCount.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getCredentialUsageSummary")
    @JsonIgnore
    public CollectionPageNonEntityRequest<CredentialUsageSummary> getCredentialUsageSummary(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCredentialUsageSummary"), CredentialUsageSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getRelyingPartyDetailedSummary")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RelyingPartyDetailedSummary> getRelyingPartyDetailedSummary(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRelyingPartyDetailedSummary"), RelyingPartyDetailedSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "deviceConfigurationUserActivity")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> deviceConfigurationUserActivity() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deviceConfigurationUserActivity"), Report.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "deviceConfigurationDeviceActivity")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> deviceConfigurationDeviceActivity() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.deviceConfigurationDeviceActivity"), Report.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "managedDeviceEnrollmentFailureDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentFailureDetails() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentFailureDetails"), Report.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "managedDeviceEnrollmentFailureDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentFailureDetails_Function(Integer skip, Integer top, String filter, String skipToken) {
        Preconditions.checkNotNull(skip, "skip cannot be null");
        Preconditions.checkNotNull(top, "top cannot be null");
        Preconditions.checkNotNull(filter, "filter cannot be null");
        Preconditions.checkNotNull(skipToken, "skipToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .put("skipToken", "Edm.String", Checks.checkIsAscii(skipToken))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentFailureDetails"), Report.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "managedDeviceEnrollmentFailureTrends")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentFailureTrends() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentFailureTrends"), Report.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "managedDeviceEnrollmentTopFailures")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentTopFailures() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentTopFailures"), Report.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "managedDeviceEnrollmentTopFailures")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentTopFailures_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentTopFailures"), Report.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "managedDeviceEnrollmentAbandonmentSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentAbandonmentSummary(Integer skip, Integer top, String filter, String skipToken) {
        Preconditions.checkNotNull(skip, "skip cannot be null");
        Preconditions.checkNotNull(top, "top cannot be null");
        Preconditions.checkNotNull(filter, "filter cannot be null");
        Preconditions.checkNotNull(skipToken, "skipToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .put("skipToken", "Edm.String", Checks.checkIsAscii(skipToken))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentAbandonmentSummary"), Report.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "managedDeviceEnrollmentAbandonmentDetails")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> managedDeviceEnrollmentAbandonmentDetails(Integer skip, Integer top, String filter, String skipToken) {
        Preconditions.checkNotNull(skip, "skip cannot be null");
        Preconditions.checkNotNull(top, "top cannot be null");
        Preconditions.checkNotNull(filter, "filter cannot be null");
        Preconditions.checkNotNull(skipToken, "skipToken cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("skip", "Edm.Int32", skip)
            .put("top", "Edm.Int32", top)
            .put("filter", "Edm.String", Checks.checkIsAscii(filter))
            .put("skipToken", "Edm.String", Checks.checkIsAscii(skipToken))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.managedDeviceEnrollmentAbandonmentDetails"), Report.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOffice365ActivationsUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ActivationsUserDetail> getOffice365ActivationsUserDetail() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActivationsUserDetail"), Office365ActivationsUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOffice365ActivationCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ActivationCounts> getOffice365ActivationCounts() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActivationCounts"), Office365ActivationCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOffice365ActivationsUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ActivationsUserCounts> getOffice365ActivationsUserCounts() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActivationsUserCounts"), Office365ActivationsUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOffice365ActiveUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ActiveUserDetail> getOffice365ActiveUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActiveUserDetail"), Office365ActiveUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOffice365ActiveUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ActiveUserDetail> getOffice365ActiveUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActiveUserDetail"), Office365ActiveUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOffice365ServicesUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ServicesUserCounts> getOffice365ServicesUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ServicesUserCounts"), Office365ServicesUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOffice365ActiveUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365ActiveUserCounts> getOffice365ActiveUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365ActiveUserCounts"), Office365ActiveUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOffice365GroupsActivityDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityDetail> getOffice365GroupsActivityDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityDetail"), Office365GroupsActivityDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOffice365GroupsActivityDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityDetail> getOffice365GroupsActivityDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityDetail"), Office365GroupsActivityDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOffice365GroupsActivityCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityCounts> getOffice365GroupsActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityCounts"), Office365GroupsActivityCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOffice365GroupsActivityGroupCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityGroupCounts> getOffice365GroupsActivityGroupCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityGroupCounts"), Office365GroupsActivityGroupCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOffice365GroupsActivityStorage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityStorage> getOffice365GroupsActivityStorage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityStorage"), Office365GroupsActivityStorage.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOffice365GroupsActivityFileCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Office365GroupsActivityFileCounts> getOffice365GroupsActivityFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOffice365GroupsActivityFileCounts"), Office365GroupsActivityFileCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getEmailActivityUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailActivityUserDetail> getEmailActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailActivityUserDetail"), EmailActivityUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getEmailActivityUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailActivityUserDetail> getEmailActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailActivityUserDetail"), EmailActivityUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getEmailActivityCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailActivitySummary> getEmailActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailActivityCounts"), EmailActivitySummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getEmailActivityUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailActivitySummary> getEmailActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailActivityUserCounts"), EmailActivitySummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getEmailAppUsageUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAppUsageUserDetail> getEmailAppUsageUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageUserDetail"), EmailAppUsageUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getEmailAppUsageUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAppUsageUserDetail> getEmailAppUsageUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageUserDetail"), EmailAppUsageUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getEmailAppUsageAppsUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAppUsageAppsUserCounts> getEmailAppUsageAppsUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageAppsUserCounts"), EmailAppUsageAppsUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getEmailAppUsageUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAppUsageUserCounts> getEmailAppUsageUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageUserCounts"), EmailAppUsageUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getEmailAppUsageVersionsUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<EmailAppUsageVersionsUserCounts> getEmailAppUsageVersionsUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getEmailAppUsageVersionsUserCounts"), EmailAppUsageVersionsUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getMailboxUsageDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MailboxUsageDetail> getMailboxUsageDetail(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailboxUsageDetail"), MailboxUsageDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getMailboxUsageMailboxCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MailboxUsageMailboxCounts> getMailboxUsageMailboxCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailboxUsageMailboxCounts"), MailboxUsageMailboxCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getMailboxUsageQuotaStatusMailboxCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MailboxUsageQuotaStatusMailboxCounts> getMailboxUsageQuotaStatusMailboxCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailboxUsageQuotaStatusMailboxCounts"), MailboxUsageQuotaStatusMailboxCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getMailboxUsageStorage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<MailboxUsageStorage> getMailboxUsageStorage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getMailboxUsageStorage"), MailboxUsageStorage.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOneDriveActivityUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OneDriveActivityUserDetail> getOneDriveActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveActivityUserDetail"), OneDriveActivityUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOneDriveActivityUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OneDriveActivityUserDetail> getOneDriveActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveActivityUserDetail"), OneDriveActivityUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOneDriveActivityUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SiteActivitySummary> getOneDriveActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveActivityUserCounts"), SiteActivitySummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOneDriveActivityFileCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SiteActivitySummary> getOneDriveActivityFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveActivityFileCounts"), SiteActivitySummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOneDriveUsageAccountDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OneDriveUsageAccountDetail> getOneDriveUsageAccountDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageAccountDetail"), OneDriveUsageAccountDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOneDriveUsageAccountDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OneDriveUsageAccountDetail> getOneDriveUsageAccountDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageAccountDetail"), OneDriveUsageAccountDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOneDriveUsageAccountCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OneDriveUsageAccountCounts> getOneDriveUsageAccountCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageAccountCounts"), OneDriveUsageAccountCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOneDriveUsageFileCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OneDriveUsageFileCounts> getOneDriveUsageFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageFileCounts"), OneDriveUsageFileCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOneDriveUsageStorage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SiteUsageStorage> getOneDriveUsageStorage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOneDriveUsageStorage"), SiteUsageStorage.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSharePointActivityUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SharePointActivityUserDetail> getSharePointActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityUserDetail"), SharePointActivityUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSharePointActivityUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SharePointActivityUserDetail> getSharePointActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityUserDetail"), SharePointActivityUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSharePointActivityFileCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SiteActivitySummary> getSharePointActivityFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityFileCounts"), SiteActivitySummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSharePointActivityUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SharePointActivityUserCounts> getSharePointActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityUserCounts"), SharePointActivityUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSharePointActivityPages")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SharePointActivityPages> getSharePointActivityPages(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointActivityPages"), SharePointActivityPages.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSharePointSiteUsageDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SharePointSiteUsageDetail> getSharePointSiteUsageDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageDetail"), SharePointSiteUsageDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSharePointSiteUsageDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SharePointSiteUsageDetail> getSharePointSiteUsageDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageDetail"), SharePointSiteUsageDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSharePointSiteUsageFileCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SharePointSiteUsageFileCounts> getSharePointSiteUsageFileCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageFileCounts"), SharePointSiteUsageFileCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSharePointSiteUsageSiteCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SharePointSiteUsageSiteCounts> getSharePointSiteUsageSiteCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageSiteCounts"), SharePointSiteUsageSiteCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSharePointSiteUsageStorage")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SiteUsageStorage> getSharePointSiteUsageStorage(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsageStorage"), SiteUsageStorage.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSharePointSiteUsagePages")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SharePointSiteUsagePages> getSharePointSiteUsagePages(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSharePointSiteUsagePages"), SharePointSiteUsagePages.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessActivityUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessActivityUserDetail> getSkypeForBusinessActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessActivityUserDetail"), SkypeForBusinessActivityUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessActivityUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessActivityUserDetail> getSkypeForBusinessActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessActivityUserDetail"), SkypeForBusinessActivityUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessActivityCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessActivityCounts> getSkypeForBusinessActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessActivityCounts"), SkypeForBusinessActivityCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessActivityUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessActivityUserCounts> getSkypeForBusinessActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessActivityUserCounts"), SkypeForBusinessActivityUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessPeerToPeerActivityCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessPeerToPeerActivityCounts> getSkypeForBusinessPeerToPeerActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessPeerToPeerActivityCounts"), SkypeForBusinessPeerToPeerActivityCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessPeerToPeerActivityUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessPeerToPeerActivityUserCounts> getSkypeForBusinessPeerToPeerActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessPeerToPeerActivityUserCounts"), SkypeForBusinessPeerToPeerActivityUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessPeerToPeerActivityMinuteCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessPeerToPeerActivityMinuteCounts> getSkypeForBusinessPeerToPeerActivityMinuteCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessPeerToPeerActivityMinuteCounts"), SkypeForBusinessPeerToPeerActivityMinuteCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessOrganizerActivityCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessOrganizerActivityCounts> getSkypeForBusinessOrganizerActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessOrganizerActivityCounts"), SkypeForBusinessOrganizerActivityCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessOrganizerActivityUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessOrganizerActivityUserCounts> getSkypeForBusinessOrganizerActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessOrganizerActivityUserCounts"), SkypeForBusinessOrganizerActivityUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessOrganizerActivityMinuteCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessOrganizerActivityMinuteCounts> getSkypeForBusinessOrganizerActivityMinuteCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessOrganizerActivityMinuteCounts"), SkypeForBusinessOrganizerActivityMinuteCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessParticipantActivityCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessParticipantActivityCounts> getSkypeForBusinessParticipantActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessParticipantActivityCounts"), SkypeForBusinessParticipantActivityCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessParticipantActivityUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessParticipantActivityUserCounts> getSkypeForBusinessParticipantActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessParticipantActivityUserCounts"), SkypeForBusinessParticipantActivityUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessParticipantActivityMinuteCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessParticipantActivityMinuteCounts> getSkypeForBusinessParticipantActivityMinuteCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessParticipantActivityMinuteCounts"), SkypeForBusinessParticipantActivityMinuteCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessDeviceUsageUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessDeviceUsageUserDetail> getSkypeForBusinessDeviceUsageUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessDeviceUsageUserDetail"), SkypeForBusinessDeviceUsageUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessDeviceUsageUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessDeviceUsageUserDetail> getSkypeForBusinessDeviceUsageUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessDeviceUsageUserDetail"), SkypeForBusinessDeviceUsageUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessDeviceUsageDistributionUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessDeviceUsageDistributionUserCounts> getSkypeForBusinessDeviceUsageDistributionUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessDeviceUsageDistributionUserCounts"), SkypeForBusinessDeviceUsageDistributionUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getSkypeForBusinessDeviceUsageUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<SkypeForBusinessDeviceUsageUserCounts> getSkypeForBusinessDeviceUsageUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getSkypeForBusinessDeviceUsageUserCounts"), SkypeForBusinessDeviceUsageUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getYammerActivityUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<YammerActivityUserDetail> getYammerActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerActivityUserDetail"), YammerActivityUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getYammerActivityUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<YammerActivityUserDetail> getYammerActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerActivityUserDetail"), YammerActivityUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getYammerActivityCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<YammerActivitySummary> getYammerActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerActivityCounts"), YammerActivitySummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getYammerActivityUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<YammerActivitySummary> getYammerActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerActivityUserCounts"), YammerActivitySummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getYammerDeviceUsageUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<YammerDeviceUsageUserDetail> getYammerDeviceUsageUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerDeviceUsageUserDetail"), YammerDeviceUsageUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getYammerDeviceUsageUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<YammerDeviceUsageUserDetail> getYammerDeviceUsageUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerDeviceUsageUserDetail"), YammerDeviceUsageUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getYammerDeviceUsageDistributionUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<YammerDeviceUsageDistributionUserCounts> getYammerDeviceUsageDistributionUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerDeviceUsageDistributionUserCounts"), YammerDeviceUsageDistributionUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getYammerDeviceUsageUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<YammerDeviceUsageUserCounts> getYammerDeviceUsageUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerDeviceUsageUserCounts"), YammerDeviceUsageUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getYammerGroupsActivityDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<YammerGroupsActivityDetail> getYammerGroupsActivityDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerGroupsActivityDetail"), YammerGroupsActivityDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getYammerGroupsActivityDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<YammerGroupsActivityDetail> getYammerGroupsActivityDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerGroupsActivityDetail"), YammerGroupsActivityDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getYammerGroupsActivityGroupCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<YammerGroupsActivityGroupCounts> getYammerGroupsActivityGroupCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerGroupsActivityGroupCounts"), YammerGroupsActivityGroupCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getYammerGroupsActivityCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<YammerGroupsActivityCounts> getYammerGroupsActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getYammerGroupsActivityCounts"), YammerGroupsActivityCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getTeamsUserActivityUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TeamsUserActivityUserDetail> getTeamsUserActivityUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityUserDetail"), TeamsUserActivityUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getTeamsUserActivityUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TeamsUserActivityUserDetail> getTeamsUserActivityUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityUserDetail"), TeamsUserActivityUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getTeamsUserActivityCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TeamsUserActivityCounts> getTeamsUserActivityCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityCounts"), TeamsUserActivityCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getTeamsUserActivityUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TeamsUserActivityUserCounts> getTeamsUserActivityUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsUserActivityUserCounts"), TeamsUserActivityUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getTeamsDeviceUsageUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TeamsDeviceUsageUserDetail> getTeamsDeviceUsageUserDetail(LocalDate date) {
        Preconditions.checkNotNull(date, "date cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("date", "Edm.Date", date)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageUserDetail"), TeamsDeviceUsageUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getTeamsDeviceUsageUserDetail")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TeamsDeviceUsageUserDetail> getTeamsDeviceUsageUserDetail_Function(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageUserDetail"), TeamsDeviceUsageUserDetail.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getTeamsDeviceUsageUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TeamsDeviceUsageUserCounts> getTeamsDeviceUsageUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageUserCounts"), TeamsDeviceUsageUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getTeamsDeviceUsageDistributionUserCounts")
    @JsonIgnore
    public CollectionPageNonEntityRequest<TeamsDeviceUsageDistributionUserCounts> getTeamsDeviceUsageDistributionUserCounts(String period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.String", Checks.checkIsAscii(period))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTeamsDeviceUsageDistributionUserCounts"), TeamsDeviceUsageDistributionUserCounts.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getTenantSecureScores")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Report> getTenantSecureScores(Integer period) {
        Preconditions.checkNotNull(period, "period cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("period", "Edm.Int32", period)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<Report>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getTenantSecureScores"), Report.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
