package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.RemoteAssistancePartner;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class RemoteAssistancePartnerRequest extends EntityRequest<RemoteAssistancePartner> {

    public RemoteAssistancePartnerRequest(ContextPath contextPath) {
        super(RemoteAssistancePartner.class, contextPath, SchemaInfo.INSTANCE);
    }

    @Action(name = "beginOnboarding")
    @JsonIgnore
    public ActionRequestNoReturn beginOnboarding() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.beginOnboarding"), _parameters);
    }

    @Action(name = "disconnect")
    @JsonIgnore
    public ActionRequestNoReturn disconnect() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.disconnect"), _parameters);
    }

}
