package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.RbacApplication;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleDefinitionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class RbacApplicationRequest extends EntityRequest<RbacApplication> {

    public RbacApplicationRequest(ContextPath contextPath) {
        super(RbacApplication.class, contextPath, SchemaInfo.INSTANCE);
    }

    public UnifiedRoleDefinitionCollectionRequest roleDefinitions() {
        return new UnifiedRoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"));
    }

    public UnifiedRoleDefinitionRequest roleDefinitions(String id) {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinitions").addKeys(new NameValue(id.toString())));
    }

    public UnifiedRoleAssignmentCollectionRequest roleAssignments() {
        return new UnifiedRoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"));
    }

    public UnifiedRoleAssignmentRequest roleAssignments(String id) {
        return new UnifiedRoleAssignmentRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id.toString())));
    }

}
