package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.RbacApplicationMultiple;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleAssignmentMultipleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UnifiedRoleDefinitionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class RbacApplicationMultipleRequest extends EntityRequest<RbacApplicationMultiple> {

    public RbacApplicationMultipleRequest(ContextPath contextPath) {
        super(RbacApplicationMultiple.class, contextPath, SchemaInfo.INSTANCE);
    }

    public UnifiedRoleDefinitionCollectionRequest roleDefinitions() {
        return new UnifiedRoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"));
    }

    public UnifiedRoleDefinitionRequest roleDefinitions(String id) {
        return new UnifiedRoleDefinitionRequest(contextPath.addSegment("roleDefinitions").addKeys(new NameValue(id.toString())));
    }

    public UnifiedRoleAssignmentMultipleCollectionRequest roleAssignments() {
        return new UnifiedRoleAssignmentMultipleCollectionRequest(
                        contextPath.addSegment("roleAssignments"));
    }

    public UnifiedRoleAssignmentMultipleRequest roleAssignments(String id) {
        return new UnifiedRoleAssignmentMultipleRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id.toString())));
    }

}
