package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.PurchaseInvoice;
import odata.msgraph.client.beta.entity.collection.request.PurchaseInvoiceLineCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PurchaseInvoiceRequest extends EntityRequest<PurchaseInvoice> {

    public PurchaseInvoiceRequest(ContextPath contextPath) {
        super(PurchaseInvoice.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PurchaseInvoiceLineCollectionRequest purchaseInvoiceLines() {
        return new PurchaseInvoiceLineCollectionRequest(
                        contextPath.addSegment("purchaseInvoiceLines"));
    }

    public PurchaseInvoiceLineRequest purchaseInvoiceLines(String id) {
        return new PurchaseInvoiceLineRequest(contextPath.addSegment("purchaseInvoiceLines").addKeys(new NameValue(id.toString())));
    }

    public VendorRequest vendor() {
        return new VendorRequest(contextPath.addSegment("vendor"));
    }

    public CurrencyRequest currency() {
        return new CurrencyRequest(contextPath.addSegment("currency"));
    }

    @Action(name = "post")
    @JsonIgnore
    public ActionRequestNoReturn post() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.post"), _parameters);
    }

}
