package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.PurchaseInvoiceLine;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PurchaseInvoiceLineRequest extends EntityRequest<PurchaseInvoiceLine> {

    public PurchaseInvoiceLineRequest(ContextPath contextPath) {
        super(PurchaseInvoiceLine.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ItemRequest item() {
        return new ItemRequest(contextPath.addSegment("item"));
    }

    public AccountRequest account() {
        return new AccountRequest(contextPath.addSegment("account"));
    }

}
