package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PublishedResource;
import odata.msgraph.client.beta.entity.collection.request.OnPremisesAgentGroupCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PublishedResourceRequest extends EntityRequest<PublishedResource> {

    public PublishedResourceRequest(ContextPath contextPath) {
        super(PublishedResource.class, contextPath, SchemaInfo.INSTANCE);
    }

    public OnPremisesAgentGroupCollectionRequest agentGroups() {
        return new OnPremisesAgentGroupCollectionRequest(
                        contextPath.addSegment("agentGroups"));
    }

    public OnPremisesAgentGroupRequest agentGroups(String id) {
        return new OnPremisesAgentGroupRequest(contextPath.addSegment("agentGroups").addKeys(new NameValue(id.toString())));
    }

}
