package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Program;
import odata.msgraph.client.beta.entity.collection.request.ProgramControlCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ProgramRequest extends EntityRequest<Program> {

    public ProgramRequest(ContextPath contextPath) {
        super(Program.class, contextPath, SchemaInfo.INSTANCE);
    }

    public ProgramControlCollectionRequest controls() {
        return new ProgramControlCollectionRequest(
                        contextPath.addSegment("controls"));
    }

    public ProgramControlRequest controls(String id) {
        return new ProgramControlRequest(contextPath.addSegment("controls").addKeys(new NameValue(id.toString())));
    }

}
