package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Profile;
import odata.msgraph.client.beta.entity.collection.request.EducationalActivityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemAddressCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemEmailCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ItemPhoneCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LanguageProficiencyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonAnniversaryCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonAnnotationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonInterestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonNameCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PersonWebsiteCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ProjectParticipationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SkillProficiencyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.UserAccountInformationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WebAccountCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.WorkPositionCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class ProfileRequest extends EntityRequest<Profile> {

    public ProfileRequest(ContextPath contextPath) {
        super(Profile.class, contextPath, SchemaInfo.INSTANCE);
    }

    public UserAccountInformationCollectionRequest account() {
        return new UserAccountInformationCollectionRequest(
                        contextPath.addSegment("account"));
    }

    public UserAccountInformationRequest account(String id) {
        return new UserAccountInformationRequest(contextPath.addSegment("account").addKeys(new NameValue(id.toString())));
    }

    public ItemAddressCollectionRequest addresses() {
        return new ItemAddressCollectionRequest(
                        contextPath.addSegment("addresses"));
    }

    public ItemAddressRequest addresses(String id) {
        return new ItemAddressRequest(contextPath.addSegment("addresses").addKeys(new NameValue(id.toString())));
    }

    public PersonAnniversaryCollectionRequest anniversaries() {
        return new PersonAnniversaryCollectionRequest(
                        contextPath.addSegment("anniversaries"));
    }

    public PersonAnniversaryRequest anniversaries(String id) {
        return new PersonAnniversaryRequest(contextPath.addSegment("anniversaries").addKeys(new NameValue(id.toString())));
    }

    public EducationalActivityCollectionRequest educationalActivities() {
        return new EducationalActivityCollectionRequest(
                        contextPath.addSegment("educationalActivities"));
    }

    public EducationalActivityRequest educationalActivities(String id) {
        return new EducationalActivityRequest(contextPath.addSegment("educationalActivities").addKeys(new NameValue(id.toString())));
    }

    public ItemEmailCollectionRequest emails() {
        return new ItemEmailCollectionRequest(
                        contextPath.addSegment("emails"));
    }

    public ItemEmailRequest emails(String id) {
        return new ItemEmailRequest(contextPath.addSegment("emails").addKeys(new NameValue(id.toString())));
    }

    public PersonInterestCollectionRequest interests() {
        return new PersonInterestCollectionRequest(
                        contextPath.addSegment("interests"));
    }

    public PersonInterestRequest interests(String id) {
        return new PersonInterestRequest(contextPath.addSegment("interests").addKeys(new NameValue(id.toString())));
    }

    public LanguageProficiencyCollectionRequest languages() {
        return new LanguageProficiencyCollectionRequest(
                        contextPath.addSegment("languages"));
    }

    public LanguageProficiencyRequest languages(String id) {
        return new LanguageProficiencyRequest(contextPath.addSegment("languages").addKeys(new NameValue(id.toString())));
    }

    public PersonNameCollectionRequest names() {
        return new PersonNameCollectionRequest(
                        contextPath.addSegment("names"));
    }

    public PersonNameRequest names(String id) {
        return new PersonNameRequest(contextPath.addSegment("names").addKeys(new NameValue(id.toString())));
    }

    public ItemPhoneCollectionRequest phones() {
        return new ItemPhoneCollectionRequest(
                        contextPath.addSegment("phones"));
    }

    public ItemPhoneRequest phones(String id) {
        return new ItemPhoneRequest(contextPath.addSegment("phones").addKeys(new NameValue(id.toString())));
    }

    public WorkPositionCollectionRequest positions() {
        return new WorkPositionCollectionRequest(
                        contextPath.addSegment("positions"));
    }

    public WorkPositionRequest positions(String id) {
        return new WorkPositionRequest(contextPath.addSegment("positions").addKeys(new NameValue(id.toString())));
    }

    public ProjectParticipationCollectionRequest projects() {
        return new ProjectParticipationCollectionRequest(
                        contextPath.addSegment("projects"));
    }

    public ProjectParticipationRequest projects(String id) {
        return new ProjectParticipationRequest(contextPath.addSegment("projects").addKeys(new NameValue(id.toString())));
    }

    public PersonAnnotationCollectionRequest notes() {
        return new PersonAnnotationCollectionRequest(
                        contextPath.addSegment("notes"));
    }

    public PersonAnnotationRequest notes(String id) {
        return new PersonAnnotationRequest(contextPath.addSegment("notes").addKeys(new NameValue(id.toString())));
    }

    public SkillProficiencyCollectionRequest skills() {
        return new SkillProficiencyCollectionRequest(
                        contextPath.addSegment("skills"));
    }

    public SkillProficiencyRequest skills(String id) {
        return new SkillProficiencyRequest(contextPath.addSegment("skills").addKeys(new NameValue(id.toString())));
    }

    public WebAccountCollectionRequest webAccounts() {
        return new WebAccountCollectionRequest(
                        contextPath.addSegment("webAccounts"));
    }

    public WebAccountRequest webAccounts(String id) {
        return new WebAccountRequest(contextPath.addSegment("webAccounts").addKeys(new NameValue(id.toString())));
    }

    public PersonWebsiteCollectionRequest websites() {
        return new PersonWebsiteCollectionRequest(
                        contextPath.addSegment("websites"));
    }

    public PersonWebsiteRequest websites(String id) {
        return new PersonWebsiteRequest(contextPath.addSegment("websites").addKeys(new NameValue(id.toString())));
    }

}
