package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.PrivilegedRoleAssignmentRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PrivilegedRoleAssignmentRequestRequest extends EntityRequest<PrivilegedRoleAssignmentRequest> {

    public PrivilegedRoleAssignmentRequestRequest(ContextPath contextPath) {
        super(PrivilegedRoleAssignmentRequest.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PrivilegedRoleRequest roleInfo() {
        return new PrivilegedRoleRequest(contextPath.addSegment("roleInfo"));
    }

    @Action(name = "cancel")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignmentRequest> cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignmentRequest>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancel"), PrivilegedRoleAssignmentRequest.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
