package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.PrivilegedRoleAssignment;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PrivilegedRoleAssignmentRequest extends EntityRequest<PrivilegedRoleAssignment> {

    public PrivilegedRoleAssignmentRequest(ContextPath contextPath) {
        super(PrivilegedRoleAssignment.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PrivilegedRoleRequest roleInfo() {
        return new PrivilegedRoleRequest(contextPath.addSegment("roleInfo"));
    }

    @Action(name = "makePermanent")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment> makePermanent(String reason, String ticketNumber, String ticketSystem) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("reason", "Edm.String", Checks.checkIsAscii(reason))
            .put("ticketNumber", "Edm.String", Checks.checkIsAscii(ticketNumber))
            .put("ticketSystem", "Edm.String", Checks.checkIsAscii(ticketSystem))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.makePermanent"), PrivilegedRoleAssignment.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "makeEligible")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment> makeEligible() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrivilegedRoleAssignment>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.makeEligible"), PrivilegedRoleAssignment.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
