package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.PrivilegedApproval;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PrivilegedApprovalRequest extends EntityRequest<PrivilegedApproval> {

    public PrivilegedApprovalRequest(ContextPath contextPath) {
        super(PrivilegedApproval.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PrivilegedRoleAssignmentRequestRequest request() {
        return new PrivilegedRoleAssignmentRequestRequest(contextPath.addSegment("request"));
    }

    public PrivilegedRoleRequest roleInfo() {
        return new PrivilegedRoleRequest(contextPath.addSegment("roleInfo"));
    }

}
