package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PrivilegedAccess;
import odata.msgraph.client.beta.entity.collection.request.GovernanceResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleAssignmentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.GovernanceRoleSettingCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PrivilegedAccessRequest extends EntityRequest<PrivilegedAccess> {

    public PrivilegedAccessRequest(ContextPath contextPath) {
        super(PrivilegedAccess.class, contextPath, SchemaInfo.INSTANCE);
    }

    public GovernanceResourceCollectionRequest resources() {
        return new GovernanceResourceCollectionRequest(
                        contextPath.addSegment("resources"));
    }

    public GovernanceResourceRequest resources(String id) {
        return new GovernanceResourceRequest(contextPath.addSegment("resources").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleDefinitionCollectionRequest roleDefinitions() {
        return new GovernanceRoleDefinitionCollectionRequest(
                        contextPath.addSegment("roleDefinitions"));
    }

    public GovernanceRoleDefinitionRequest roleDefinitions(String id) {
        return new GovernanceRoleDefinitionRequest(contextPath.addSegment("roleDefinitions").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleAssignmentCollectionRequest roleAssignments() {
        return new GovernanceRoleAssignmentCollectionRequest(
                        contextPath.addSegment("roleAssignments"));
    }

    public GovernanceRoleAssignmentRequest roleAssignments(String id) {
        return new GovernanceRoleAssignmentRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleAssignmentRequestCollectionRequest roleAssignmentRequests() {
        return new GovernanceRoleAssignmentRequestCollectionRequest(
                        contextPath.addSegment("roleAssignmentRequests"));
    }

    public GovernanceRoleAssignmentRequestRequest roleAssignmentRequests(String id) {
        return new GovernanceRoleAssignmentRequestRequest(contextPath.addSegment("roleAssignmentRequests").addKeys(new NameValue(id.toString())));
    }

    public GovernanceRoleSettingCollectionRequest roleSettings() {
        return new GovernanceRoleSettingCollectionRequest(
                        contextPath.addSegment("roleSettings"));
    }

    public GovernanceRoleSettingRequest roleSettings(String id) {
        return new GovernanceRoleSettingRequest(contextPath.addSegment("roleSettings").addKeys(new NameValue(id.toString())));
    }

}
