package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PrinterShare;
import odata.msgraph.client.beta.entity.collection.request.PrintIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintUserIdentityCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PrinterShareRequest extends EntityRequest<PrinterShare> {

    public PrinterShareRequest(ContextPath contextPath) {
        super(PrinterShare.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PrinterRequest printer() {
        return new PrinterRequest(contextPath.addSegment("printer"));
    }

    public PrintUserIdentityCollectionRequest allowedUsers() {
        return new PrintUserIdentityCollectionRequest(
                        contextPath.addSegment("allowedUsers"));
    }

    public PrintUserIdentityRequest allowedUsers(String id) {
        return new PrintUserIdentityRequest(contextPath.addSegment("allowedUsers").addKeys(new NameValue(id.toString())));
    }

    public PrintIdentityCollectionRequest allowedGroups() {
        return new PrintIdentityCollectionRequest(
                        contextPath.addSegment("allowedGroups"));
    }

    public PrintIdentityRequest allowedGroups(String id) {
        return new PrintIdentityRequest(contextPath.addSegment("allowedGroups").addKeys(new NameValue(id.toString())));
    }

}
