package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.PrinterCapabilities;
import odata.msgraph.client.beta.entity.Printer;
import odata.msgraph.client.beta.entity.collection.request.PrintConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintIdentityCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskTriggerCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintUserIdentityCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PrinterRequest extends EntityRequest<Printer> {

    public PrinterRequest(ContextPath contextPath) {
        super(Printer.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PrintUserIdentityCollectionRequest allowedUsers() {
        return new PrintUserIdentityCollectionRequest(
                        contextPath.addSegment("allowedUsers"));
    }

    public PrintUserIdentityRequest allowedUsers(String id) {
        return new PrintUserIdentityRequest(contextPath.addSegment("allowedUsers").addKeys(new NameValue(id.toString())));
    }

    public PrintIdentityCollectionRequest allowedGroups() {
        return new PrintIdentityCollectionRequest(
                        contextPath.addSegment("allowedGroups"));
    }

    public PrintIdentityRequest allowedGroups(String id) {
        return new PrintIdentityRequest(contextPath.addSegment("allowedGroups").addKeys(new NameValue(id.toString())));
    }

    public PrinterShareRequest share() {
        return new PrinterShareRequest(contextPath.addSegment("share"));
    }

    public PrintConnectorCollectionRequest connectors() {
        return new PrintConnectorCollectionRequest(
                        contextPath.addSegment("connectors"));
    }

    public PrintConnectorRequest connectors(String id) {
        return new PrintConnectorRequest(contextPath.addSegment("connectors").addKeys(new NameValue(id.toString())));
    }

    public PrintTaskTriggerCollectionRequest taskTriggers() {
        return new PrintTaskTriggerCollectionRequest(
                        contextPath.addSegment("taskTriggers"));
    }

    public PrintTaskTriggerRequest taskTriggers(String id) {
        return new PrintTaskTriggerRequest(contextPath.addSegment("taskTriggers").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "resetDefaults")
    @JsonIgnore
    public ActionRequestNoReturn resetDefaults() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetDefaults"), _parameters);
    }

    @Function(name = "getCapabilities")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<PrinterCapabilities> getCapabilities() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<PrinterCapabilities>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getCapabilities"), PrinterCapabilities.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
