package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.PrinterCreateOperation;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PrinterCreateOperationRequest extends EntityRequest<PrinterCreateOperation> {

    public PrinterCreateOperationRequest(ContextPath contextPath) {
        super(PrinterCreateOperation.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PrinterRequest printer() {
        return new PrinterRequest(contextPath.addSegment("printer"));
    }

}
