package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PrinterBase;
import odata.msgraph.client.beta.entity.collection.request.PrintJobCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PrinterBaseRequest extends EntityRequest<PrinterBase> {

    public PrinterBaseRequest(ContextPath contextPath) {
        super(PrinterBase.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PrintJobCollectionRequest jobs() {
        return new PrintJobCollectionRequest(
                        contextPath.addSegment("jobs"));
    }

    public PrintJobRequest jobs(String id) {
        return new PrintJobRequest(contextPath.addSegment("jobs").addKeys(new NameValue(id.toString())));
    }

}
