package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.PrintTask;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PrintTaskRequest extends EntityRequest<PrintTask> {

    public PrintTaskRequest(ContextPath contextPath) {
        super(PrintTask.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PrintTaskDefinitionRequest definition() {
        return new PrintTaskDefinitionRequest(contextPath.addSegment("definition"));
    }

    public PrintTaskTriggerRequest trigger() {
        return new PrintTaskTriggerRequest(contextPath.addSegment("trigger"));
    }

}
