package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PrintTaskDefinition;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PrintTaskDefinitionRequest extends EntityRequest<PrintTaskDefinition> {

    public PrintTaskDefinitionRequest(ContextPath contextPath) {
        super(PrintTaskDefinition.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PrintTaskCollectionRequest tasks() {
        return new PrintTaskCollectionRequest(
                        contextPath.addSegment("tasks"));
    }

    public PrintTaskRequest tasks(String id) {
        return new PrintTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id.toString())));
    }

}
