package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PrintService;
import odata.msgraph.client.beta.entity.collection.request.PrintServiceEndpointCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PrintServiceRequest extends EntityRequest<PrintService> {

    public PrintServiceRequest(ContextPath contextPath) {
        super(PrintService.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PrintServiceEndpointCollectionRequest endpoints() {
        return new PrintServiceEndpointCollectionRequest(
                        contextPath.addSegment("endpoints"));
    }

    public PrintServiceEndpointRequest endpoints(String id) {
        return new PrintServiceEndpointRequest(contextPath.addSegment("endpoints").addKeys(new NameValue(id.toString())));
    }

}
