package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Print;
import odata.msgraph.client.beta.entity.collection.request.PrintConnectorCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintServiceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskDefinitionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrinterCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrinterShareCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ReportRootCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PrintRequest extends EntityRequest<Print> {

    public PrintRequest(ContextPath contextPath) {
        super(Print.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PrintServiceCollectionRequest services() {
        return new PrintServiceCollectionRequest(
                        contextPath.addSegment("services"));
    }

    public PrintServiceRequest services(String id) {
        return new PrintServiceRequest(contextPath.addSegment("services").addKeys(new NameValue(id.toString())));
    }

    public PrinterCollectionRequest printers() {
        return new PrinterCollectionRequest(
                        contextPath.addSegment("printers"));
    }

    public PrinterRequest printers(String id) {
        return new PrinterRequest(contextPath.addSegment("printers").addKeys(new NameValue(id.toString())));
    }

    public PrintConnectorCollectionRequest connectors() {
        return new PrintConnectorCollectionRequest(
                        contextPath.addSegment("connectors"));
    }

    public PrintConnectorRequest connectors(String id) {
        return new PrintConnectorRequest(contextPath.addSegment("connectors").addKeys(new NameValue(id.toString())));
    }

    public PrinterShareCollectionRequest shares() {
        return new PrinterShareCollectionRequest(
                        contextPath.addSegment("shares"));
    }

    public PrinterShareRequest shares(String id) {
        return new PrinterShareRequest(contextPath.addSegment("shares").addKeys(new NameValue(id.toString())));
    }

    public PrinterShareCollectionRequest printerShares() {
        return new PrinterShareCollectionRequest(
                        contextPath.addSegment("printerShares"));
    }

    public PrinterShareRequest printerShares(String id) {
        return new PrinterShareRequest(contextPath.addSegment("printerShares").addKeys(new NameValue(id.toString())));
    }

    public ReportRootCollectionRequest reports() {
        return new ReportRootCollectionRequest(
                        contextPath.addSegment("reports"));
    }

    public ReportRootRequest reports(String id) {
        return new ReportRootRequest(contextPath.addSegment("reports").addKeys(new NameValue(id.toString())));
    }

    public PrintOperationCollectionRequest operations() {
        return new PrintOperationCollectionRequest(
                        contextPath.addSegment("operations"));
    }

    public PrintOperationRequest operations(String id) {
        return new PrintOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id.toString())));
    }

    public PrintTaskDefinitionCollectionRequest taskDefinitions() {
        return new PrintTaskDefinitionCollectionRequest(
                        contextPath.addSegment("taskDefinitions"));
    }

    public PrintTaskDefinitionRequest taskDefinitions(String id) {
        return new PrintTaskDefinitionRequest(contextPath.addSegment("taskDefinitions").addKeys(new NameValue(id.toString())));
    }

}
