package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.PrintJobStatus;
import odata.msgraph.client.beta.entity.PrintJob;
import odata.msgraph.client.beta.entity.collection.request.PrintDocumentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PrintTaskCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PrintJobRequest extends EntityRequest<PrintJob> {

    public PrintJobRequest(ContextPath contextPath) {
        super(PrintJob.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PrintDocumentCollectionRequest documents() {
        return new PrintDocumentCollectionRequest(
                        contextPath.addSegment("documents"));
    }

    public PrintDocumentRequest documents(String id) {
        return new PrintDocumentRequest(contextPath.addSegment("documents").addKeys(new NameValue(id.toString())));
    }

    public PrintTaskCollectionRequest tasks() {
        return new PrintTaskCollectionRequest(
                        contextPath.addSegment("tasks"));
    }

    public PrintTaskRequest tasks(String id) {
        return new PrintTaskRequest(contextPath.addSegment("tasks").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "cancelPrintJob")
    @JsonIgnore
    public ActionRequestNoReturn cancelPrintJob() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.cancelPrintJob"), _parameters);
    }

    @Action(name = "startPrintJob")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrintJobStatus> startPrintJob() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<PrintJobStatus>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.startPrintJob"), PrintJobStatus.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "redirect")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PrintJob> redirect(String destinationPrinterId) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("destinationPrinterId", "Edm.String", Checks.checkIsAscii(destinationPrinterId))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PrintJob>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.redirect"), PrintJob.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
