package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Presentation;
import odata.msgraph.client.beta.entity.collection.request.DocumentCommentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PresentationRequest extends EntityRequest<Presentation> {

    public PresentationRequest(ContextPath contextPath) {
        super(Presentation.class, contextPath, SchemaInfo.INSTANCE);
    }

    public DocumentCommentCollectionRequest comments() {
        return new DocumentCommentCollectionRequest(
                        contextPath.addSegment("comments"));
    }

    public DocumentCommentRequest comments(String id) {
        return new DocumentCommentRequest(contextPath.addSegment("comments").addKeys(new NameValue(id.toString())));
    }

}
