package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.PolicySet;
import odata.msgraph.client.beta.entity.PolicySetAssignment;
import odata.msgraph.client.beta.entity.PolicySetItem;
import odata.msgraph.client.beta.entity.collection.request.PolicySetAssignmentCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PolicySetItemCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class PolicySetRequest extends EntityRequest<PolicySet> {

    public PolicySetRequest(ContextPath contextPath) {
        super(PolicySet.class, contextPath, SchemaInfo.INSTANCE);
    }

    public PolicySetAssignmentCollectionRequest assignments() {
        return new PolicySetAssignmentCollectionRequest(
                        contextPath.addSegment("assignments"));
    }

    public PolicySetAssignmentRequest assignments(String id) {
        return new PolicySetAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public PolicySetItemCollectionRequest items() {
        return new PolicySetItemCollectionRequest(
                        contextPath.addSegment("items"));
    }

    public PolicySetItemRequest items(String id) {
        return new PolicySetItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "update")
    @JsonIgnore
    public ActionRequestNoReturn update(List<PolicySetItem> addedPolicySetItems, List<PolicySetItem> updatedPolicySetItems, List<String> deletedPolicySetItems, List<PolicySetAssignment> assignments) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("addedPolicySetItems", "Collection(microsoft.graph.policySetItem)", addedPolicySetItems)
            .put("updatedPolicySetItems", "Collection(microsoft.graph.policySetItem)", updatedPolicySetItems)
            .put("deletedPolicySetItems", "Collection(Edm.String)", Checks.checkIsAscii(deletedPolicySetItems))
            .put("assignments", "Collection(microsoft.graph.policySetAssignment)", assignments)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.update"), _parameters);
    }

}
